<?php

namespace App\Modules\StatusGroup\Application\Index;

use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexStatusGroupQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupIndexer $inserter)
    {
    }

    public function __invoke(IndexStatusGroupQuery $query): IndexStatusGroupQueryResponse
    {
        return $this->inserter->__invoke(new IdStatusGroup($query->getId()));
    }
}
