<?php

namespace App\Modules\Shared\Application;

class Util
{

    /**
     * Last 5 generated strings
     */
    private static $LAST_GENERATED = [];
    
    public static function generateString(int $length):string
    {
        $maxAttempts = 5;
        $generatedLasts = 20;
        $generated = self::generate($length, 'abcdefghijklmnopqrstuvwxyz');
        $attempt = 1;
        while ($attempt <= $maxAttempts) {
            if (in_array($generated, self::$LAST_GENERATED)) {
                $generated = self::generate($length, 'abcdefghijklmnopqrstuvwxyz');
            } else {
                break;
            }
            $attempt++;
        }
        
        array_unshift(self::$LAST_GENERATED, $generated);
        self::$LAST_GENERATED = array_slice(self::$LAST_GENERATED, 0, $generatedLasts);
        return $generated;
    }

    public static function generateInt(int $length):string
    {
        return self::generate($length, '123456789');
    }

    public static function generate(int $length, string $values)
    {
        $str = '';
        for ($i = 0; $i < $length; $i++) {
            $ind = rand(0, strlen($values) - 1);
            $str .= $values[$ind];
        }
        return $str;
    }
}
