<?php

namespace App\Modules\ReviewNotification\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;

class ReviewNotification
{

    /** constructor */
    public function __construct(
        private ReviewNotificationDescription $description,
        private ReviewNotificationStatus $status,
        private IdAdmin $idAdmin,
        private IdLanguage $idGuideLanguage,
        private IdLanguage $idLanguage,
        private IdLead $idLead,
        private ?IdReviewNotification $id = null
    ) {
    }
    public function getDescription(): ReviewNotificationDescription
    {
        return $this->description;
    }
    public function getStatus(): ReviewNotificationStatus
    {
        return $this->status;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function getIdGuideLanguage(): IdLanguage
    {
        return $this->idGuideLanguage;
    }
    public function getIdLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }
    public function getIdLead(): IdLead
    {
        return $this->idLead;
    }
    public function getId(): IdReviewNotification
    {
        return $this->id;
    }
}
