<?php

namespace App\Modules\ReviewNotification\Application\List;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewNotificationListerQueryHandler implements QueryHandler
{
    public function __construct(private ReviewNotificationLister $lister)
    {
    }

    public function __invoke(ReviewNotificationListerQuery $query): ReviewNotificationListerResponse
    {
        return $this->lister->__invoke(
            new IdGroupPassenger($query->getIdGroupPassenger()),
            $query->getAction()
        );
    }
}
