<?php

namespace App\Modules\ReviewNotification\Application\Create;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterQuery;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterResponse;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\InsertReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationCancellationReason;
use App\Modules\ReviewNotification\Domain\ReviewNotificationCancellationRemark;
use App\Modules\ReviewNotification\Domain\ReviewNotificationContact;
use App\Modules\ReviewNotification\Domain\ReviewNotificationDescription;
use App\Modules\ReviewNotification\Domain\ReviewNotificationObservation;
use App\Modules\ReviewNotification\Domain\ReviewNotificationStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewNotificationInserterQueryHandler implements QueryHandler
{
    public function __construct(
        private ReviewNotificationInserter $inserter,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(ReviewNotificationInserterQuery $query): ReviewNotificationInserterResponse
    {
        $model = new InsertReviewNotification(
            new ReviewNotificationDescription($query->getDescription()),
            new ReviewNotificationStatus($query->getStatus()),
            new IdGroupPassenger($query->getIdGroupPassenger()),
            new IdAdmin($query->getIdAdminCreate()),
            new IdReviewNotification(0)
        );
        return $this->inserter->__invoke($model);
    }
}
