<?php

namespace App\Modules\Redistribution\Domain;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementDetail\Domain\IdCashMovementDetail;
use App\Modules\Invoice\Domain\IdInvoice;

final class InvoiceData {

    private Amount $amount;
    private IdCashMovementDetail $idCashMovementDetail;
    private IdInvoice $idInvoice;
    private IdCashMovement $idCashMovement;

    public function __construct(
        Amount $amount,
        IdCashMovementDetail $idCashMovementDetail,
        IdInvoice $idInvoice,
        IdCashMovement $idCashMovement
    ) {
        $this->amount = $amount;
        $this->idCashMovementDetail = $idCashMovementDetail;
        $this->idInvoice = $idInvoice;
        $this->idCashMovement = $idCashMovement;
    }

    public function amount(): Amount { return $this->amount; }
    public function idCashMovementDetail(): IdCashMovementDetail { return $this->idCashMovementDetail; }
    public function idInvoice(): IdInvoice { return $this->idInvoice; }
    public function idCashMovement(): IdCashMovement { return $this->idCashMovement; }

}