<?php

namespace App\Modules\QuestionTypeProvider\Application\Delete;

use App\Modules\QuestionTypeProvider\Domain\IdQuestionTypeProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class QuestionTypeProviderDeleterQueryHandler implements QueryHandler
{
    public function __construct(private QuestionTypeProviderDeleter $inserter)
    {
    }

    public function __invoke(QuestionTypeProviderDeleterQuery $query): QuestionTypeProviderDeleterResponse
    {
        return $this->inserter->__invoke(new IdQuestionTypeProvider($query->getId()));
    }
}
