<?php

namespace App\Modules\ProviderTypeProvider\Application\Delete;

use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderTypeProviderDeleterQueryHandler implements QueryHandler
{
    public function __construct(private ProviderTypeProviderDeleter $inserter)
    {
    }

    public function __invoke(ProviderTypeProviderDeleterQuery $query): ProviderTypeProviderDeleterResponse
    {
        return $this->inserter->__invoke(new IdProviderTypeProvider($query->getId()));
    }
}
