<?php

namespace App\Modules\ProviderSanction\Application\Index;

use App\Modules\ProviderSanction\Application\Index\ProviderSanctionIndexerResponse;
use App\Modules\ProviderSanction\Domain\IdProviderSanction;
use App\Modules\ProviderSanction\Domain\ProviderSanction;
use App\Modules\ProviderSanction\Domain\ProviderSanctionRepository;

final class ProviderSanctionIndexer
{
    public function __construct(private ProviderSanctionRepository $repository)
    {
    }

    public function __invoke(IdProviderSanction $idProviderSanction): ProviderSanctionIndexerResponse
    {
        return new ProviderSanctionIndexerResponse($this->repository->index($idProviderSanction));
    }
}
