<?php

namespace App\Modules\PassengerReview\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\PassengerReview\Domain\PassengerReviewSearchByGroupRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPassengerReviewSearchByGroupRepository implements PassengerReviewSearchByGroupRepository
{
    public function searchByGroup(IdGroup $idGroup, string $action, string $path)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_review_search_by_group(?,?,?,@sts,@cod,@msg)',
            [
                $idGroup->getValue(),
                $action,
                $path
            ]
        );
    }
}
