<?php

namespace App\Modules\PassengerReview\Infraestructure;

use App\Modules\PassengerReview\Domain\IdPassengerReview;
use App\Modules\PassengerReview\Domain\PassengerReviewRemoveRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPassengerReviewRemoveRepository implements PassengerReviewRemoveRepository
{
    public function remove(IdPassengerReview $idReview)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_review_delete(?,@sts,@cod,@msg)',
            [
                $idReview->value()
            ]
        );
    }
}
