<?php

namespace App\Modules\Passenger\Domain;

class PassengerCheckedInStatus
{

    public const NOT_CONFIRMED = 1;
    public const CONFIRMED = 2;

    private int $value;

    public function __construct(int $value)
    {
        $values = [self::NOT_CONFIRMED, self::CONFIRMED];
        $this->value = in_array($value, $values) ? $value : $values[0];
    }

    public function getValue()
    {
        return $this->value;
    }

    public function value()
    {
        return $this->value;
    }

    public function toString()
    {
        switch ($this->value) {
            case self::NOT_CONFIRMED:
                return 'NO CONFIRMADO';
                break;
            case self::CONFIRMED:
                return 'CONFIRMADO';
                break;
        }
    }
}
