<?php

namespace App\Modules\Passenger\Application\Index;

use App\Modules\Passenger\Application\Index\PassengerIndexerResponse;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerRepository;

final class PassengerIndexer
{
    public function __construct(private PassengerRepository $repository)
    {
    }

    public function __invoke(IdPassenger $idPassenger): PassengerIndexerResponse
    {
        return new PassengerIndexerResponse($this->repository->index($idPassenger));
    }
}
