<?php

namespace App\Modules\Passenger\Application\ExcelReviewReport;

use App\Modules\Passenger\Domain\PassengerSearchWithReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class PassengerExcelReviewReporter
{
    public function __construct(private PassengerSearchWithReviewRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $action
    ): PassengerReviewReportResponse {
        return new PassengerReviewReportResponse(
            $this->repository->reviewReport(
                $dateStart,
                $dateEnd,
                $range,
                $action
            )
        );
    }
}
