<?php

namespace App\Modules\PackageFee\Application\GetFull;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class PackageFeeGetFullQueryHandler implements QueryHandler
{
    public function __construct(private PackageFeeFullGetter $fullGetter)
    {
    }

    public function __invoke(PackageFeeGetFullQuery $query): PackageFeeGetFullQueryResponse
    {
        return $this->fullGetter->__invoke(new IdPackage($query->idPackage()));
    }
}
