<?php

namespace App\Modules\PackageFee\Application\GetFull;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\PackageFee\Domain\PackageFeeFullCriteria;
use App\Modules\PackageFee\Domain\PackageFeeRepository;
use App\Modules\PackageFee\Domain\PackageFeeType;

final class PackageFeeFullGetter
{
    public function __construct(
        private PackageFeeRepository $repository,
    ) {
    }

    public function __invoke(IdPackage $idPackage): PackageFeeGetFullQueryResponse
    {
        $packageFeeList = $this->repository->list($idPackage);

        $packageFeeFull = (new PackageFeeFullCriteria())->meetCriteria($packageFeeList);
        $amount = array_reduce($packageFeeFull, fn($carry, $pf) => $carry + $pf->PackageFee_Amount, 0);
        $type = count($packageFeeFull) ? $packageFeeFull[0]->PackageFee_Type : PackageFeeType::defaultValue();

        return new PackageFeeGetFullQueryResponse($amount, $type);
    }
}
