<?php

namespace App\Modules\Package\Application\GetCampSchedule;

use App\Modules\HtlCampSchedule\Domain\Calendar;

class PackageTour
{

    public array $htlCamps = [];
    public array $availability = [];
    public array $lockList = [];
    public Calendar $schedule;

    public function __construct(
        public int $idTour,
        public int $tourMinPax,
        public int $tourAvailability,
        public int $tourAvailabilityStatus,
        public int $day
    ) {
    }

    public function generateSchedule($dateTimeStart, $dateTimeEnd)
    {
        $availability = new DataGroup($this->availability, 'BookingTour_DateStart');
        $lockList = new DataGroup($this->lockList, 'TourLock_DateStart');
        $this->schedule = new Calendar($dateTimeStart, $dateTimeEnd);
        $v = $this;
        $this->schedule->generate(function ($date) use ($availability, $lockList, &$v) {
            $avail = $availability->getObject($date);
            $lock = $lockList->getObject($date);
            return (object)[
                'date'      => $date,
                'availabilityStatus' => $v->tourAvailabilityStatus == 2,
                'paxFree'   => $avail ? $v->tourAvailability - $avail->pax : $v->tourAvailability,
                'paxAmount' => $avail ? $avail->pax : 0,
                'paxMin'    => $v->tourMinPax,
                'lock'      => $lock ? 1 : 0
            ];
        });
    }
}
