<?php

namespace App\Modules\Media\Domain;

class Media
{
    public function __construct(
        private MediaInputName $inputName,
        private MediaInputStore $inputStore,
        private MediaHasLarge $hasLarge
    ) {
    }

    public function inputName(): MediaInputName
    {
        return $this->inputName;
    }

    public function inputStore(): MediaInputStore
    {
        return $this->inputStore;
    }

    public function hasLarge(): MediaHasLarge
    {
        return $this->hasLarge;
    }

    public function isImage(): bool
    {
        return $this->inputStore->value() === 'image';
    }

    public function isVideo(): bool
    {
        return $this->inputStore->value() === 'video';
    }
}
