<?php

namespace App\Modules\Media\Application\Delete;

use App\Modules\Media\Domain\MediaPath;
use App\Modules\Media\Domain\MediaRepository;

final class MediaDeleter
{
    public function __construct(
        private MediaRepository $repository
    ) {
    }

    public function __invoke(MediaPath $path)
    {
        return $this->repository->delete($path);
    }
}
