<?php

namespace App\Modules\LeadPassenger\Application\Index;

use App\Modules\LeadPassenger\Application\Index\LeadPassengerIndexerResponse;
use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;

final class LeadPassengerIndexer
{
    public function __construct(private LeadPassengerRepository $repository)
    {
    }

    public function __invoke(IdLeadPassenger $idLeadPassenger): LeadPassengerIndexerResponse
    {
        return new LeadPassengerIndexerResponse($this->repository->index($idLeadPassenger));
    }
}
