<?php

namespace App\Modules\LeadPassenger\Application\Delete;

use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadPassengerDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadPassengerDeleter $inserter)
    {
    }

    public function __invoke(LeadPassengerDeleterQuery $query): LeadPassengerDeleterResponse
    {
        return $this->inserter->__invoke(new IdLeadPassenger($query->getId()));
    }
}
