<?php

namespace App\Modules\LeadPassenger\Application\Delete;

use App\Modules\LeadPassenger\Application\Delete\LeadPassengerDeleterResponse;
use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;

final class LeadPassengerDeleter
{
    public function __construct(private LeadPassengerRepository $repository)
    {
    }

    public function __invoke(IdLeadPassenger $idLeadPassenger): LeadPassengerDeleterResponse
    {
        return new LeadPassengerDeleterResponse($this->repository->delete($idLeadPassenger));
    }
}
