<?php

namespace App\Modules\LeadBookingTourPassenger\Infraestructure;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassenger;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerRepository;
use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadBookingTourPassengerRepository implements LeadBookingTourPassengerRepository
{

    public function find(IdLeadBookingTour $idLeadBookingTour, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_tour_passenger_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBookingTour->value(),
                $action
            ]
        );
    }

    public function index(IdLeadBookingTourPassenger $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_tour_passenger_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(LeadBookingTourPassenger $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_tour_passenger_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getStatus()->value(),
                $value->getIdLeadBookingTour()->value(),
                $value->getIdLeadPassenger()->value(),
            ]
        );
    }

    public function update(LeadBookingTourPassenger $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_tour_passenger_update(?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getStatus()->value()
            ]
        );
    }

    public function delete(IdLeadBookingTourPassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_tour_passenger_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
