<?php

namespace App\Modules\LeadBookingTour\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingTourInserterQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $pickUp,
        private int $type,
        private int $noPax,
        private int $group,
        private int $status,
        private int $idLeadBooking,
        private int $idPackage,
        private int $idTour
    ) {
    }

    public function getDateStart(): string
    {
        return $this->dateStart;
    }
    public function getPickUp(): string
    {
        return $this->pickUp;
    }
    public function getType(): int
    {
        return $this->type;
    }
    public function getNoPax(): int
    {
        return $this->noPax;
    }
    public function getGroup(): int
    {
        return $this->group;
    }
    public function getStatus(): int
    {
        return $this->status;
    }
    public function getIdLeadBooking(): int
    {
        return $this->idLeadBooking;
    }
    public function getIdPackage(): int
    {
        return $this->idPackage;
    }
    public function getIdTour(): int
    {
        return $this->idTour;
    }
}
