<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Update;

use App\Modules\LeadBookingServicePassenger\Application\Update\LeadBookingServicePassengerUpdaterResponse;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;
use App\Modules\LeadBookingServicePassenger\Domain\UpdateLeadBookingServicePassenger;

final class LeadBookingServicePassengerUpdater
{
    public function __construct(private LeadBookingServicePassengerRepository $repository)
    {
    }

    public function __invoke(
        LeadBookingServicePassenger $leadBookingServicePassenger
    ): LeadBookingServicePassengerUpdaterResponse {
        return new LeadBookingServicePassengerUpdaterResponse($this->repository->update($leadBookingServicePassenger));
    }
}
