<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Index;

use App\Modules\LeadBookingServicePassenger\Domain\IdLeadBookingServicePassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServicePassengerIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServicePassengerIndexer $inserter)
    {
    }

    public function __invoke(LeadBookingServicePassengerIndexerQuery $query): LeadBookingServicePassengerIndexerResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingServicePassenger($query->getId()));
    }
}
