<?php

namespace App\Modules\LeadBookingService\Application\Delete;

use App\Modules\LeadBookingService\Application\Delete\LeadBookingServiceDeleterResponse;
use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;

final class LeadBookingServiceDeleter
{
    public function __construct(private LeadBookingServiceRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingService $idLeadBookingService): LeadBookingServiceDeleterResponse
    {
        return new LeadBookingServiceDeleterResponse($this->repository->delete($idLeadBookingService));
    }
}
