<?php

namespace App\Modules\LeadBooking\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $leadBookingObservation,
        private int $leadBookingContact,
        private int $leadBookingCancellationReason,
        private string $leadBookingCancellationRemark,
        private int $leadBookingStatus,
        private int $idAdmin,
        private int $idGuideLanguage,
        private int $idLanguage,
        private int $idLead
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getObservation(): string
    {
        return $this->leadBookingObservation;
    }
    public function getContact(): int
    {
        return $this->leadBookingContact;
    }
    public function getCancellationReason(): int
    {
        return $this->leadBookingCancellationReason;
    }
    public function getCancellationRemark(): string
    {
        return $this->leadBookingCancellationRemark;
    }
    public function getStatus(): int
    {
        return $this->leadBookingStatus;
    }
    public function getIdAdmin(): int
    {
        return $this->idAdmin;
    }
    public function getIdGuideLanguage(): int
    {
        return $this->idGuideLanguage;
    }
    public function getIdLanguage(): int
    {
        return $this->idLanguage;
    }
    public function getIdLead(): int
    {
        return $this->idLead;
    }
}
