<?php

namespace App\Modules\LeadBooking\Application\Create;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterQuery;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterResponse;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\LeadBooking\Domain\LeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingCancellationReason;
use App\Modules\LeadBooking\Domain\LeadBookingCancellationRemark;
use App\Modules\LeadBooking\Domain\LeadBookingContact;
use App\Modules\LeadBooking\Domain\LeadBookingObservation;
use App\Modules\LeadBooking\Domain\LeadBookingStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingInserterQueryHandler implements QueryHandler
{
    public function __construct(
        private LeadBookingInserter $inserter,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(LeadBookingInserterQuery $query): LeadBookingInserterResponse
    {
        /** @var AdminSessionGetterResponse */
        $admin = $this->queryBus->ask(new AdminSessionGetterQuery($query->token()));
        $model = new LeadBooking(
            new LeadBookingObservation($query->getObservation()),
            new LeadBookingContact($query->getContact()),
            new LeadBookingCancellationReason(LeadBookingCancellationReason::OTROS),
            new LeadBookingCancellationRemark(''),
            new LeadBookingStatus($query->getStatus()),
            new IdAdmin($admin->response()[0]->Response_Id_Admin),
            new IdLanguage($query->getIdGuideLanguage()),
            new IdLanguage($query->getIdLanguage()),
            new IdLead($query->getIdLead()),
        );
        return $this->inserter->__invoke($model);
    }
}
