<?php

namespace App\Modules\Lead\Application\Update;

use App\Modules\Lead\Domain\IdLead;
use App\Modules\Lead\Domain\Lead;
use App\Modules\Lead\Domain\LeadAddress;
use App\Modules\Lead\Domain\LeadContactName;
use App\Modules\Lead\Domain\LeadContactPhone;
use App\Modules\Lead\Domain\LeadEmail;
use App\Modules\Lead\Domain\LeadGender;
use App\Modules\Lead\Domain\LeadLastName;
use App\Modules\Lead\Domain\LeadName;
use App\Modules\Lead\Domain\LeadNoDocument;
use App\Modules\Lead\Domain\LeadPhone;
use App\Modules\Lead\Domain\LeadPhoneCode;
use App\Modules\Lead\Domain\LeadStatus;
use App\Modules\Lead\Domain\LeadType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class LeadUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadUpdater $updater)
    {
    }

    public function __invoke(LeadUpdaterQuery $query): LeadUpdaterResponse
    {
        $model = new Lead(
            new LeadName($query->getName()),
            new LeadLastName($query->getLastName()),
            new LeadGender($query->getGender()),
            new LeadEmail($query->getEmail()),
            new LeadPhoneCode($query->getPhoneCode()),
            new LeadPhone($query->getPhone()),
            new LeadNoDocument($query->getNoDocument()),
            new LeadAddress($query->getAddress()),
            new LeadContactName($query->getContactName()),
            new LeadContactPhone($query->getContactPhone()),
            new LeadType($query->getType()),
            new LeadStatus($query->getStatus()),
            new IdTypeDocument($query->getIdTypeDocument()),
            new IdUserCountry($query->getIdUserCountry()),
            new IdLead($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
