<?php

namespace App\Modules\Invoice\Application\Index;

use App\Modules\Invoice\Application\Index\IndexInvoiceResponse;
use App\Modules\Invoice\Domain\IdInvoice;
use App\Modules\Invoice\Domain\InvoiceRepository;

final class InvoiceIndexer
{
    public function __construct(private InvoiceRepository $repository)
    {
    }

    public function __invoke(IdInvoice $idInvoice): IndexInvoiceResponse
    {
        return new IndexInvoiceResponse($this->repository->index($idInvoice));
    }
}
