<?php

namespace App\Modules\Image\Application;

use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Image\Domain\Image;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Shared\Application\WrapperResponse;

class ImageCreator {

    private ImageRepository $repository;

    public function __construct(
        ImageRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke (Image $image, IdLanguage $idLanguage):WrapperResponse {
        return $this->repository->insert($image, $idLanguage);
    }
}