<?php

namespace App\Modules\HtlTypeRoom\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlTypeRoom\Application\HtlTypeRoomResponse;
use App\Modules\HtlTypeRoom\Application\HtlTypeRoomResponses;
use App\Modules\HtlTypeRoom\Domain\HtlTypeRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlTypeRoomQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeRoomLister $lister)
    {
    }

    public function __invoke(ListHtlTypeRoomQuery $query): HtlTypeRoomResponses
    {
        return new HtlTypeRoomResponses(...array_map(
            fn (HtlTypeRoom $index) => new HtlTypeRoomResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
                $index->idHtlCamp()->value(),
            ),
            $this->lister->__invoke(new IdHtlCamp($query->getIdHtlCamp()), $query->getAction())
        ));
    }
}
