<?php

namespace App\Modules\HtlTypeCamp\Application\Index;

use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\HtlTypeCamp\Domain\HtlTypeCampRepository;
use App\Modules\HtlTypeCamp\Domain\IndexHtlTypeCamp;

final class HtlTypeCampIndexer
{
    public function __construct(private HtlTypeCampRepository $repository)
    {
    }

    public function __invoke(IdHtlTypeCamp $idHtlTypeCamp, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexHtlTypeCamp($idHtlTypeCamp, $lockInShare));
        return $index;
    }
}
