<?php

namespace App\Modules\HtlCampSchedule\Infrastructure;

use App\Modules\HtlCampSchedule\Domain\HtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleListModel;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleRepository;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlHtlCampScheduleRepository implements HtlCampScheduleRepository
{

    public function find(StorageCriteria $criteria): HtlCampSchedule | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlCampSchedule::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => HtlCampScheduleListModel::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlCampSchedule $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlCampSchedule $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
