<?php

namespace App\Modules\HtlCampSchedule\Application\ReloadAmount;

use App\Modules\HtlCampBooking\Application\HtlCampBookingResponses;
use App\Modules\HtlCampBooking\Application\ListBySchedule\ListByScheduleHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingStatus;
use App\Modules\HtlCampLock\Application\HtlCampLockResponses;
use App\Modules\HtlCampLock\Application\List\ListHtlCampLockQuery;
use App\Modules\HtlCampSchedule\Application\Index\HtlCampScheduleIndexer;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAmountUsage;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReloadAmountHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampScheduleAmountReloader $updater,
        private HtlCampScheduleIndexer $indexer,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(ReloadAmountHtlCampScheduleQuery $query)
    {
        $index = $this->indexer->__invoke(new IdHtlCampSchedule($query->id()), true);

        /** @var HtlCampBookingResponses $bookings */
        $bookings = $this->queryBus->ask(new ListByScheduleHtlCampBookingQuery($index->id()->value(), 'active'));

        /** @var HtlCampLockResponses $locks */
        $locks = $this->queryBus->ask(new ListHtlCampLockQuery($index->id()->value(), 'pending'));

        $amount = $index->amountUsage()->value();
        $newAmount = $this->getBookingsAmount($bookings->data(), $locks->data());

        if ($amount !== $newAmount) {
            $index->setAmountUsage(new HtlCampScheduleAmountUsage($newAmount));
            $this->updater->__invoke($index);
        }
        return;
    }

    private function getBookingsAmount(array $bookings, array $locks): int
    {
        $amountBookings = array_reduce(
            array_filter(
                $bookings,
                fn ($booking) => $booking->HtlCampBooking_Status === HtlCampBookingStatus::ACTIVE
            ),
            fn ($acc, $booking) => $acc + $booking->HtlCampBooking_Amount,
            0
        );

        $amountLocks = array_reduce(
            $locks,
            fn ($acc, $lock) => $acc + $lock->HtlCampLock_Amount,
            0
        );
        return $amountBookings + $amountLocks;
    }
}
