<?php

namespace App\Modules\HtlCampSchedule\Application\List;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleRepository;
use App\Modules\HtlCampSchedule\Domain\ListHtlCampSchedule;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class HtlCampScheduleLister
{
    public function __construct(private HtlCampScheduleRepository $repository)
    {
    }

    public function __invoke(IdHtlCamp $idHtlCamp, DateTimeStart $dateTimeStart, DateTimeEnd $dateTimeEnd)
    {
        return $this->repository->search(new ListHtlCampSchedule($idHtlCamp, $dateTimeStart, $dateTimeEnd));
    }
}
