<?php

namespace App\Modules\HtlCampSchedule\Application\AddUsage;

use App\Modules\HtlCampSchedule\Application\Update\HtlCampScheduleUpdater;
use App\Modules\HtlCampSchedule\Domain\HtlCampSchedule;
use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleAmountUsage;
use App\Modules\Shared\Exceptions\InvalidRequestException;

final class HtlCampScheduleUsageAdder
{
    public function __construct(
        private HtlCampScheduleUpdater $updater
    ) {
    }

    public function __invoke(HtlCampSchedule $model, int $amount)
    {
        $model->setAmountUsage(new HtlCampScheduleAmountUsage($model->amountUsage()->value() + $amount));
        return $this->updater->__invoke($model);
    }
}
