<?php

namespace App\Modules\HtlCampLock\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class HtlCampLockNotExists extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            400,
            ErrorDictionary::ERRORS['INTERNAL']['HTL_CAMP_LOCK']['HTL_CAMP_LOCK_EXISTS']['HTL_CAMP_LOCK_NOT_EXISTS'],
            'Bloqueo de campamento no existe'
        );
    }
}
