<?php

namespace App\Modules\HtlCampLock\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlCampLock extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampLock::class, 'Id_HtlCampLock', 'primary'),
            new AggregateAttribute('date', HtlCampLockDate::class, 'HtlCampLock_Date'),
            new AggregateAttribute('dateStart', HtlCampLockDateStart::class, 'HtlCampLock_DateStart'),
            new AggregateAttribute('amount', HtlCampLockAmount::class, 'HtlCampLock_Amount'),
            new AggregateAttribute('status', HtlCampLockStatus::class, 'HtlCampLock_Status'),
            new AggregateAttribute('idHtlCampSchedule', IdHtlCampSchedule::class, 'Id_HtlCampSchedule'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_lock';
    }

    public function __construct(
        protected IdHtlCampLock $id,
        protected HtlCampLockDate $date,
        protected HtlCampLockDateStart $dateStart,
        protected HtlCampLockAmount $amount,
        protected HtlCampLockStatus $status,
        protected IdHtlCampSchedule $idHtlCampSchedule,
    ) {
    }

    public function id(): IdHtlCampLock
    {
        return $this->id;
    }

    public function date(): HtlCampLockDate
    {
        return $this->date;
    }

    public function dateStart(): HtlCampLockDateStart
    {
        return $this->dateStart;
    }

    public function amount(): HtlCampLockAmount
    {
        return $this->amount;
    }

    public function status(): HtlCampLockStatus
    {
        return $this->status;
    }

    public function idHtlCampSchedule(): IdHtlCampSchedule
    {
        return $this->idHtlCampSchedule;
    }

    public function setDate(HtlCampLockDate $date): void
    {
        $this->date = $date;
    }

    public function setDateStart(HtlCampLockDateStart $dateStart): void
    {
        $this->dateStart = $dateStart;
    }

    public function setAmount(HtlCampLockAmount $amount): void
    {
        $this->amount = $amount;
    }

    public function setStatus(HtlCampLockStatus $status): void
    {
        $this->status = $status;
    }

    public function setIdHtlCampSchedule(IdHtlCampSchedule $idHtlCampSchedule): void
    {
        $this->idHtlCampSchedule = $idHtlCampSchedule;
    }

    public function delete()
    {
        $this->status = HtlCampLockStatus::deletedValue();
    }

    public static function generate(
        HtlCampLockDateStart $dateStart,
        HtlCampLockAmount $amount,
        IdHtlCampSchedule $idHtlCampSchedule,
    ) {
        return new HtlCampLock(
            new IdHtlCampLock(0),
            HtlCampLockDate::now(),
            $dateStart,
            $amount,
            HtlCampLockStatus::defaultValue(),
            $idHtlCampSchedule,
        );
    }
}
