<?php

namespace App\Modules\HtlCampLock\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateHtlCampLockQuery implements Query
{
    public function __construct(
        private int $id,
        private string $dateStart,
        private string $remark,
        private int $status,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function remark(): string
    {
        return $this->remark;
    }

    public function status(): int
    {
        return $this->status;
    }
}
