<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Booking\Domain\BookingInPerson;
use App\Modules\Booking\Domain\BookingType;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Domain\UserType;
use App\Modules\BookingTour\Domain\BookingTourDateStart;
use App\Modules\BookingTour\Domain\BookingTourStatus;
use App\Modules\BookingTour\Domain\BookingTourTourDuration;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerHasBeenPrinted;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerStatus;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Invoice\Domain\IdInvoice;
use App\Modules\Invoice\Domain\InvoiceTotal;
use App\Modules\Invoice\Domain\InvoiceTotalPending;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerCheckedInStatus;
use App\Modules\Passenger\Domain\PassengerDOB;
use App\Modules\Passenger\Domain\PassengerGender;
use App\Modules\Passenger\Domain\PassengerImageDocument1;
use App\Modules\Passenger\Domain\PassengerInfoStatus;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Passenger\Domain\PassengerPaymentStatus;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\Tour\Domain\TourCode;
use App\Modules\Tour\Domain\TourColor;
use App\Modules\Tour\Domain\TourName;
use App\Modules\User\Domain\IdUser;
use App\Modules\UserCountry\Domain\IdUserCountry;
use App\Modules\UserCountry\Domain\UserCountryCode;
use App\Modules\UserCountry\Domain\UserCountryImg;
use App\Modules\UserCountry\Domain\UserCountryName;
use App\Modules\UserCountry\Domain\UserCountryPhoneCode;
use App\Modules\UserCountry\Domain\UserCountryStatus;

class ListByScheduleHtlCampBookingPassengerModel extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('Id_HtlCampBookingPassenger', IdHtlCampBookingPassenger::class, 'Id_HtlCampBookingPassenger'),
            new AggregateAttribute('HtlCampBookingPassenger_Status', HtlCampBookingPassengerStatus::class, 'HtlCampBookingPassenger_Status'),
            new AggregateAttribute('Id_Invoice', IdInvoice::class, 'Id_Invoice'),
            new AggregateAttribute('Invoice_TotalPending', InvoiceTotalPending::class, 'Invoice_TotalPending'),
            new AggregateAttribute('Invoice_Total', InvoiceTotal::class, 'Invoice_Total'),
            new AggregateAttribute('Id_Passenger', IdPassenger::class, 'Id_Passenger'),
            new AggregateAttribute('Passenger_ImgDocument1', PassengerImageDocument1::class, 'Passenger_ImgDocument1'),
            new AggregateAttribute('Passenger_Gender', PassengerGender::class, 'Passenger_Gender'),
            new AggregateAttribute('Passenger_DOB', PassengerDOB::class, 'Passenger_DOB'),
            new AggregateAttribute('BookingTour_DateStart', BookingTourDateStart::class, 'BookingTour_DateStart'),
            new AggregateAttribute('BookingTour_TourDuration', BookingTourTourDuration::class, 'BookingTour_TourDuration'),
            new AggregateAttribute('Passenger_CheckedInStatus', PassengerCheckedInStatus::class, 'Passenger_CheckedInStatus'),
            new AggregateAttribute('Passenger_InfoStatus', PassengerInfoStatus::class, 'Passenger_InfoStatus'),
            new AggregateAttribute('Passenger_PaymentStatus', PassengerPaymentStatus::class, 'Passenger_PaymentStatus'),
            new AggregateAttribute('Id_BookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('BookingTourPassenger_HasBeenPrinted', BookingTourPassengerHasBeenPrinted::class, 'BookingTourPassenger_HasBeenPrinted'),
            new AggregateAttribute('BookingTourPassenger_Status', BookingTourPassengerStatus::class, 'BookingTourPassenger_Status'),
            new AggregateAttribute('BookingTour_Status', BookingTourStatus::class, 'BookingTour_Status'),
            new AggregateAttribute('Passenger_Name', PassengerName::class, 'Passenger_Name'),
            new AggregateAttribute('Passenger_LastName', PassengerLastName::class, 'Passenger_LastName'),
            new AggregateAttribute('Id_UserCountry', IdUserCountry::class, 'Id_UserCountry'),
            new AggregateAttribute('UserCountry_Name', UserCountryName::class, 'UserCountry_Name'),
            new AggregateAttribute('UserCountry_Code', UserCountryCode::class, 'UserCountry_Code'),
            new AggregateAttribute('UserCountry_PhoneCode', UserCountryPhoneCode::class, 'UserCountry_PhoneCode'),
            new AggregateAttribute('UserCountry_Img', UserCountryImg::class, 'UserCountry_Img'),
            new AggregateAttribute('UserCountry_Status', UserCountryStatus::class, 'UserCountry_Status'),
            new AggregateAttribute('Id_Tour', IdTour::class, 'Id_Tour'),
            new AggregateAttribute('Tour_Name', TourName::class, 'Tour_Name'),
            new AggregateAttribute('Tour_Code', TourCode::class, 'Tour_Code'),
            new AggregateAttribute('Tour_Color', TourColor::class, 'Tour_Color'),
            new AggregateAttribute('Id_User', IdUser::class, 'Id_User'),
            new AggregateAttribute('User_Type', UserType::class, 'User_Type'),
            new AggregateAttribute('Id_Booking', IdBooking::class, 'Id_Booking'),
            new AggregateAttribute('Booking_Type', BookingType::class, 'Booking_Type'),
            new AggregateAttribute('Booking_InPerson', BookingInPerson::class, 'Booking_InPerson'),
            new AggregateAttribute('Booking_Code', BookingCode::class, 'Booking_Code'),
            new AggregateAttribute('Id_Admin', IdAdmin::class, 'Id_Admin'),
            new AggregateAttribute('GroupList', GroupList::class, 'GroupList'),
            new AggregateAttribute('Group_Count', GroupCount::class, 'Group_Count'),
            new AggregateAttribute('Id_Group', IdGroup::class, 'Id_Group'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_booking_passenger';
    }

    public function __construct(
        public IdHtlCampBookingPassenger $Id_HtlCampBookingPassenger,
        public HtlCampBookingPassengerStatus $HtlCampBookingPassenger_Status,
        public IdInvoice $Id_Invoice,
        public InvoiceTotalPending $Invoice_TotalPending,
        public InvoiceTotal $Invoice_Total,
        public IdPassenger $Id_Passenger,
        public PassengerImageDocument1 $Passenger_ImgDocument1,
        public PassengerGender $Passenger_Gender,
        public PassengerDOB $Passenger_DOB,
        public BookingTourDateStart $BookingTour_DateStart,
        public BookingTourTourDuration $BookingTour_TourDuration,
        public PassengerCheckedInStatus $Passenger_CheckedInStatus,
        public PassengerInfoStatus $Passenger_InfoStatus,
        public PassengerPaymentStatus $Passenger_PaymentStatus,
        public IdBookingTourPassenger $Id_BookingTourPassenger,
        public BookingTourPassengerHasBeenPrinted $BookingTourPassenger_HasBeenPrinted,
        public BookingTourPassengerStatus $BookingTourPassenger_Status,
        public BookingTourStatus $BookingTour_Status,
        public PassengerName $Passenger_Name,
        public PassengerLastName $Passenger_LastName,
        public IdUserCountry $Id_UserCountry,
        public UserCountryName $UserCountry_Name,
        public UserCountryCode $UserCountry_Code,
        public UserCountryPhoneCode $UserCountry_PhoneCode,
        public UserCountryImg $UserCountry_Img,
        public UserCountryStatus $UserCountry_Status,
        public IdTour $Id_Tour,
        public TourName $Tour_Name,
        public TourCode $Tour_Code,
        public TourColor $Tour_Color,
        public IdUser $Id_User,
        public UserType $User_Type,
        public IdBooking $Id_Booking,
        public BookingType $Booking_Type,
        public BookingInPerson $Booking_InPerson,
        public BookingCode $Booking_Code,
        public IdAdmin $Id_Admin,
        public GroupList $GroupList,
        public GroupCount $Group_Count,
        public ?IdGroup $Id_Group,
    ) {
    }
}
