<?php

namespace App\Modules\HtlCampBookingPassenger\Application\List;

use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBookingPassenger\Domain\ListHtlCampBookingPassengerModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListHtlCampBookingPassengerQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampBookingPassengerLister $lister)
    {
    }

    public function __invoke(ListHtlCampBookingPassengerQuery $query): ListHtlCampBookingPassengerResponses
    {
        return new ListHtlCampBookingPassengerResponses(...array_map(
            fn (ListHtlCampBookingPassengerModel $index) => new ListHtlCampBookingPassengerResponse(
                $index->id()->value(),
                $index->weight()->value(),
                $index->status()->value(),
                $index->idHtlCampBooking()->value(),
                $index->idBookingTourPassenger()->value(),
                $index->bookingTourPassengerStatus()->value(),
                $index->passengerName()->value(),
                $index->passengerLastName()->value(),
                $index->passengerOrder()->value(),
            ),
            $this->lister->__invoke(new IdHtlCampBooking($query->getIdHtlCampBooking()), $query->getAction())
        ));
    }
}
