<?php

namespace App\Modules\HtlCampBooking\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCamp\Domain\HtlCampAbrv;
use App\Modules\HtlCamp\Domain\HtlCampIcon;
use App\Modules\HtlCamp\Domain\HtlCampIconThumb;
use App\Modules\HtlCamp\Domain\HtlCampName;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class ListHtlCampBookingModel extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampBooking::class, 'Id_HtlCampBooking', 'primary'),
            new AggregateAttribute('date', HtlCampBookingDate::class, 'HtlCampBooking_Date'),
            new AggregateAttribute('dateStart', HtlCampBookingDateStart::class, 'HtlCampBooking_DateStart'),
            new AggregateAttribute('amount', HtlCampBookingAmount::class, 'HtlCampBooking_Amount'),
            new AggregateAttribute('amountTotal', HtlCampBookingAmountTotal::class, 'HtlCampBooking_AmountTotal'),
            new AggregateAttribute('status', HtlCampBookingStatus::class, 'HtlCampBooking_Status'),
            new AggregateAttribute('lock', HtlCampBookingLock::class, 'HtlCampBooking_Lock'),
            new AggregateAttribute('remark', HtlCampBookingRemark::class, 'HtlCampBooking_Remark'),
            new AggregateAttribute('idHtlCampSchedule', IdHtlCampSchedule::class, 'Id_HtlCampSchedule'),
            new AggregateAttribute('idBookingTour', IdBookingTour::class, 'Id_BookingTour'),
            new AggregateAttribute('idHtlCamp', IdHtlCamp::class, 'Id_HtlCamp'),
            new AggregateAttribute('name', HtlCampName::class, 'HtlCamp_Name'),
            new AggregateAttribute('abrv', HtlCampAbrv::class, 'HtlCamp_Abrv'),
            new AggregateAttribute('icon', HtlCampIcon::class, 'HtlCamp_Icon'),
            new AggregateAttribute('iconThumb', HtlCampIconThumb::class, 'HtlCamp_Icon_Thumb'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_booking';
    }

    public function __construct(
        protected IdHtlCampBooking $id,
        protected HtlCampBookingDate $date,
        protected HtlCampBookingDateStart $dateStart,
        protected HtlCampBookingAmount $amount,
        protected HtlCampBookingAmountTotal $amountTotal,
        protected HtlCampBookingStatus $status,
        protected HtlCampBookingLock $lock,
        protected HtlCampBookingRemark $remark,
        protected IdHtlCampSchedule $idHtlCampSchedule,
        protected IdBookingTour $idBookingTour,
        protected IdHtlCamp $idHtlCamp,
        protected HtlCampName $name,
        protected HtlCampAbrv $abrv,
        protected HtlCampIcon $icon,
        protected HtlCampIconThumb $iconThumb,
    ) {
    }

    public function id(): IdHtlCampBooking
    {
        return $this->id;
    }

    public function date(): HtlCampBookingDate
    {
        return $this->date;
    }

    public function dateStart(): HtlCampBookingDateStart
    {
        return $this->dateStart;
    }

    public function amount(): HtlCampBookingAmount
    {
        return $this->amount;
    }

    public function amountTotal(): HtlCampBookingAmountTotal
    {
        return $this->amountTotal;
    }

    public function status(): HtlCampBookingStatus
    {
        return $this->status;
    }

    public function lock(): HtlCampBookingLock
    {
        return $this->lock;
    }

    public function remark(): HtlCampBookingRemark
    {
        return $this->remark;
    }

    public function idHtlCampSchedule(): IdHtlCampSchedule
    {
        return $this->idHtlCampSchedule;
    }

    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }

    public function idHtlCamp(): IdHtlCamp
    {
        return $this->idHtlCamp;
    }

    public function name(): HtlCampName
    {
        return $this->name;
    }

    public function abrv(): HtlCampAbrv
    {
        return $this->abrv;
    }

    public function icon(): HtlCampIcon
    {
        return $this->icon;
    }

    public function iconThumb(): HtlCampIconThumb
    {
        return $this->iconThumb;
    }
}
