<?php

namespace App\Modules\HtlCampBooking\Application\Update;

use App\Modules\HtlCampBooking\Application\Index\HtlCampBookingIndexer;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmount;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDate;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDateStart;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingLock;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRemark;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingUpdater $updater,
        private HtlCampBookingIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlCampBookingQuery $query): UpdateHtlCampBookingResponse
    {
        $index = $this->indexer->__invoke(new IdHtlCampBooking($query->id()), true);
        $lastDateStart = $index->dateStart();
        $index->setRemark(new HtlCampBookingRemark($query->remark()));
        if (!$index->isLocked()) {
            $index->setDateStart(new HtlCampBookingDateStart($query->dateStart()));
            $index->setStatus(new HtlCampBookingStatus($query->status()));
        }

        $this->updater->__invoke($index);
        return new UpdateHtlCampBookingResponse();
    }
}
