<?php

namespace App\Modules\HtlCamp\Domain;

use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;

class InsertHtlCamp
{

    private HtlCampName $name;
    private HtlCampAbrv $abrv;
    private HtlCampIcon $icon;
    private HtlCampIconThumb $iconThumb;
    private HtlCampAvailability $availability;
    private HtlCampStatus $status;
    private IdHtlTypeCamp $idHtlTypeCamp;
    private ?IdHtlCamp $id;


    /** constructor */
    public function __construct(
        HtlCampName $name,
        HtlCampAbrv $abrv,
        HtlCampIcon $icon,
        HtlCampIconThumb $iconThumb,
        HtlCampAvailability $availability,
        HtlCampStatus $status,
        IdHtlTypeCamp $idHtlTypeCamp,
        ?IdHtlCamp $id = NULL
    ) {
        $this->name = $name;
        $this->abrv = $abrv;
        $this->icon = $icon;
        $this->iconThumb = $iconThumb;
        $this->availability = $availability;
        $this->status = $status;
        $this->idHtlTypeCamp = $idHtlTypeCamp;
        $this->id = $id;
    }

    public function getName(): HtlCampName
    {
        return $this->name;
    }
    public function getAbrv(): HtlCampAbrv
    {
        return $this->abrv;
    }
    public function getIcon(): HtlCampIcon
    {
        return $this->icon;
    }
    public function getIconThumb(): HtlCampIconThumb
    {
        return $this->iconThumb;
    }
    public function getAvailability(): HtlCampAvailability
    {
        return $this->availability;
    }
    public function getStatus(): HtlCampStatus
    {
        return $this->status;
    }
    public function getIdHtlTypeCamp(): IdHtlTypeCamp
    {
        return $this->idHtlTypeCamp;
    }
    public function getId(): IdHtlCamp
    {
        return $this->id;
    }
}
