<?php

namespace App\Modules\HtlBed\Application\Delete;

use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\HtlBed\Domain\HtlBedAbrv;
use App\Modules\HtlBed\Domain\HtlBedName;
use App\Modules\HtlBed\Domain\HtlBedStatus;
use App\Modules\HtlBed\Domain\HtlBedType;
use App\Modules\HtlBed\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\HtlBed\Application\Index\HtlBedIndexer;
use App\Modules\HtlBed\Application\Update\HtlBedUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlBedQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlBedUpdater $update,
        private HtlBedIndexer $indexer
    ) {
    }

    public function __invoke(DeleteHtlBedQuery $query): DeleteHtlBedResponse
    {
        $index = $this->indexer->__invoke(new IdHtlBed($query->idHtlBed()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlBedResponse();
    }
}
