<?php

namespace App\Modules\History\Application\List;

use App\Modules\History\Domain\HistoryRepository;
use App\Modules\History\Domain\IdHistoryReference;
use App\Modules\History\Domain\ListHistory;
use App\Modules\HistoryTable\Domain\IdHistoryTable;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;

final class HistoryLister
{
    public function __construct(private HistoryRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        IdHistoryTable $idHistoryTable,
        IdHistoryReference $idHistoryReference,
        QueryPaginate $paginate,
        string $action
    ) {
        return $this->repository->search(new ListHistory(
            $dateStart,
            $dateEnd,
            $idHistoryTable,
            $idHistoryReference,
            $paginate,
            $action
        ));
    }
}
