<?php

namespace App\Modules\GroupProviderMedia\Application\Index;

use App\Modules\GroupProviderMedia\Application\GroupProviderMediaResponse;
use App\Modules\GroupProviderMedia\Domain\IdGroupProviderMedia;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexGroupProviderMediaQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderMediaIndexer $inserter)
    {
    }

    public function __invoke(IndexGroupProviderMediaQuery $query): GroupProviderMediaResponse
    {
        $model = $this->inserter->__invoke(new IdGroupProviderMedia($query->getId()));
        return new GroupProviderMediaResponse(
            $model->id()->value(),
            $model->path()->value(),
            $model->pathThumb()->value(),
            $model->pathLargeThumb()->value(),
            $model->description()->value(),
            $model->extension()->value(),
            $model->size()->value(),
            $model->type()->value(),
            $model->hasThumbnail()->value(),
            $model->error()->value(),
            $model->status()->value(),
            $model->idGroupProvider()->value(),
        );
    }
}
