<?php

namespace App\Modules\GroupProvider\Application\UpdateStatus;

use App\Modules\GroupProvider\Application\Index\GroupProviderIndexer;
use App\Modules\GroupProvider\Domain\GroupProvider;
use App\Modules\GroupProvider\Domain\GroupProviderMediaDateUpdate;
use App\Modules\GroupProvider\Domain\GroupProviderMediaStatus;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\IdGroupProvider;

final class StatusGroupProviderUpdater
{
    public function __construct(
        private GroupProviderRepository $repository,
        private GroupProviderIndexer $groupPassengerIndexer
    ) {
    }

    public function __invoke(IdGroupProvider $id, GroupProviderMediaStatus $mediaStatus)
    {
        /** @var GroupProvider $index */
        $index = $this->groupPassengerIndexer->__invoke($id);
        $index->setMediaStatus($mediaStatus);
        $index->setMediaDateUpdate(GroupProviderMediaDateUpdate::reduceDatetimeToPeru(GroupProviderMediaDateUpdate::now()));
        return $this->repository->updateModel($index);
    }
}
